# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Moto(object):
    _types = {
        "moto_id": str,
        "id": str,
        "user_name": str,
        "type": str,
    }

    def __init__(self, d=None):
        self.moto_id: Optional[str] = None
        self.id: Optional[str] = None
        self.user_name: Optional[str] = None
        self.type: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MotoBuilder":
        return MotoBuilder()


class MotoBuilder(object):
    def __init__(self) -> None:
        self._moto = Moto()

    def moto_id(self, moto_id: str) -> "MotoBuilder":
        self._moto.moto_id = moto_id
        return self

    def id(self, id: str) -> "MotoBuilder":
        self._moto.id = id
        return self

    def user_name(self, user_name: str) -> "MotoBuilder":
        self._moto.user_name = user_name
        return self

    def type(self, type: str) -> "MotoBuilder":
        self._moto.type = type
        return self

    def build(self) -> "Moto":
        return self._moto
