# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Agent(object):
    _types = {
        "id": str,
        "avatar_url": str,
        "name": str,
        "email": str,
        "department": str,
        "company_name": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.avatar_url: Optional[str] = None
        self.name: Optional[str] = None
        self.email: Optional[str] = None
        self.department: Optional[str] = None
        self.company_name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AgentBuilder":
        return AgentBuilder()


class AgentBuilder(object):
    def __init__(self) -> None:
        self._agent = Agent()

    def id(self, id: str) -> "AgentBuilder":
        self._agent.id = id
        return self

    def avatar_url(self, avatar_url: str) -> "AgentBuilder":
        self._agent.avatar_url = avatar_url
        return self

    def name(self, name: str) -> "AgentBuilder":
        self._agent.name = name
        return self

    def email(self, email: str) -> "AgentBuilder":
        self._agent.email = email
        return self

    def department(self, department: str) -> "AgentBuilder":
        self._agent.department = department
        return self

    def company_name(self, company_name: str) -> "AgentBuilder":
        self._agent.company_name = company_name
        return self

    def build(self) -> "Agent":
        return self._agent
