# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .agent_skill_less_info import AgentSkillLessInfo
from .agent_user import AgentUser
from .weekday_schedule import WeekdaySchedule


class AgentSchedule(object):
    _types = {
        "status": int,
        "agent": AgentUser,
        "schedule": List[WeekdaySchedule],
        "agent_skills": List[AgentSkillLessInfo],
    }

    def __init__(self, d=None):
        self.status: Optional[int] = None
        self.agent: Optional[AgentUser] = None
        self.schedule: Optional[List[WeekdaySchedule]] = None
        self.agent_skills: Optional[List[AgentSkillLessInfo]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AgentScheduleBuilder":
        return AgentScheduleBuilder()


class AgentScheduleBuilder(object):
    def __init__(self) -> None:
        self._agent_schedule = AgentSchedule()

    def status(self, status: int) -> "AgentScheduleBuilder":
        self._agent_schedule.status = status
        return self

    def agent(self, agent: AgentUser) -> "AgentScheduleBuilder":
        self._agent_schedule.agent = agent
        return self

    def schedule(self, schedule: List[WeekdaySchedule]) -> "AgentScheduleBuilder":
        self._agent_schedule.schedule = schedule
        return self

    def agent_skills(self, agent_skills: List[AgentSkillLessInfo]) -> "AgentScheduleBuilder":
        self._agent_schedule.agent_skills = agent_skills
        return self

    def build(self) -> "AgentSchedule":
        return self._agent_schedule
