# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .agent import Agent
from .agent_skill_rule import AgentSkillRule


class AgentSkill(object):
    _types = {
        "id": str,
        "helpdesk_id": str,
        "name": str,
        "rules": List[AgentSkillRule],
        "agent_ids": List[str],
        "is_default": bool,
        "agents": List[Agent],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.helpdesk_id: Optional[str] = None
        self.name: Optional[str] = None
        self.rules: Optional[List[AgentSkillRule]] = None
        self.agent_ids: Optional[List[str]] = None
        self.is_default: Optional[bool] = None
        self.agents: Optional[List[Agent]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AgentSkillBuilder":
        return AgentSkillBuilder()


class AgentSkillBuilder(object):
    def __init__(self) -> None:
        self._agent_skill = AgentSkill()

    def id(self, id: str) -> "AgentSkillBuilder":
        self._agent_skill.id = id
        return self

    def helpdesk_id(self, helpdesk_id: str) -> "AgentSkillBuilder":
        self._agent_skill.helpdesk_id = helpdesk_id
        return self

    def name(self, name: str) -> "AgentSkillBuilder":
        self._agent_skill.name = name
        return self

    def rules(self, rules: List[AgentSkillRule]) -> "AgentSkillBuilder":
        self._agent_skill.rules = rules
        return self

    def agent_ids(self, agent_ids: List[str]) -> "AgentSkillBuilder":
        self._agent_skill.agent_ids = agent_ids
        return self

    def is_default(self, is_default: bool) -> "AgentSkillBuilder":
        self._agent_skill.is_default = is_default
        return self

    def agents(self, agents: List[Agent]) -> "AgentSkillBuilder":
        self._agent_skill.agents = agents
        return self

    def build(self) -> "AgentSkill":
        return self._agent_skill
