# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class AgentSkillRule(object):
    _types = {
        "id": str,
        "selected_operator": int,
        "operator_options": List[int],
        "operand": str,
        "category": int,
        "display_name": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.selected_operator: Optional[int] = None
        self.operator_options: Optional[List[int]] = None
        self.operand: Optional[str] = None
        self.category: Optional[int] = None
        self.display_name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AgentSkillRuleBuilder":
        return AgentSkillRuleBuilder()


class AgentSkillRuleBuilder(object):
    def __init__(self) -> None:
        self._agent_skill_rule = AgentSkillRule()

    def id(self, id: str) -> "AgentSkillRuleBuilder":
        self._agent_skill_rule.id = id
        return self

    def selected_operator(self, selected_operator: int) -> "AgentSkillRuleBuilder":
        self._agent_skill_rule.selected_operator = selected_operator
        return self

    def operator_options(self, operator_options: List[int]) -> "AgentSkillRuleBuilder":
        self._agent_skill_rule.operator_options = operator_options
        return self

    def operand(self, operand: str) -> "AgentSkillRuleBuilder":
        self._agent_skill_rule.operand = operand
        return self

    def category(self, category: int) -> "AgentSkillRuleBuilder":
        self._agent_skill_rule.category = category
        return self

    def display_name(self, display_name: str) -> "AgentSkillRuleBuilder":
        self._agent_skill_rule.display_name = display_name
        return self

    def build(self) -> "AgentSkillRule":
        return self._agent_skill_rule
