# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_agent_schedule_request_body import CreateAgentScheduleRequestBody


class CreateAgentScheduleRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[CreateAgentScheduleRequestBody] = None

    @staticmethod
    def builder() -> "CreateAgentScheduleRequestBuilder":
        return CreateAgentScheduleRequestBuilder()


class CreateAgentScheduleRequestBuilder(object):

    def __init__(self) -> None:
        create_agent_schedule_request = CreateAgentScheduleRequest()
        create_agent_schedule_request.http_method = HttpMethod.POST
        create_agent_schedule_request.uri = "/open-apis/helpdesk/v1/agent_schedules"
        create_agent_schedule_request.token_types = {AccessTokenType.USER}
        self._create_agent_schedule_request: CreateAgentScheduleRequest = create_agent_schedule_request

    def request_body(self, request_body: CreateAgentScheduleRequestBody) -> "CreateAgentScheduleRequestBuilder":
        self._create_agent_schedule_request.request_body = request_body
        self._create_agent_schedule_request.body = request_body
        return self

    def build(self) -> CreateAgentScheduleRequest:
        return self._create_agent_schedule_request
