# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .category import Category


class CreateCategoryRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[Category] = None

    @staticmethod
    def builder() -> "CreateCategoryRequestBuilder":
        return CreateCategoryRequestBuilder()


class CreateCategoryRequestBuilder(object):

    def __init__(self) -> None:
        create_category_request = CreateCategoryRequest()
        create_category_request.http_method = HttpMethod.POST
        create_category_request.uri = "/open-apis/helpdesk/v1/categories"
        create_category_request.token_types = {AccessTokenType.USER}
        self._create_category_request: CreateCategoryRequest = create_category_request

    def request_body(self, request_body: Category) -> "CreateCategoryRequestBuilder":
        self._create_category_request.request_body = request_body
        self._create_category_request.body = request_body
        return self

    def build(self) -> CreateCategoryRequest:
        return self._create_category_request
