# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .ticket_customized_field import TicketCustomizedField


class CreateTicketCustomizedFieldRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[TicketCustomizedField] = None

    @staticmethod
    def builder() -> "CreateTicketCustomizedFieldRequestBuilder":
        return CreateTicketCustomizedFieldRequestBuilder()


class CreateTicketCustomizedFieldRequestBuilder(object):

    def __init__(self) -> None:
        create_ticket_customized_field_request = CreateTicketCustomizedFieldRequest()
        create_ticket_customized_field_request.http_method = HttpMethod.POST
        create_ticket_customized_field_request.uri = "/open-apis/helpdesk/v1/ticket_customized_fields"
        create_ticket_customized_field_request.token_types = {AccessTokenType.USER}
        self._create_ticket_customized_field_request: CreateTicketCustomizedFieldRequest = create_ticket_customized_field_request

    def request_body(self, request_body: TicketCustomizedField) -> "CreateTicketCustomizedFieldRequestBuilder":
        self._create_ticket_customized_field_request.request_body = request_body
        self._create_ticket_customized_field_request.body = request_body
        return self

    def build(self) -> CreateTicketCustomizedFieldRequest:
        return self._create_ticket_customized_field_request
