# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_ticket_message_request_body import CreateTicketMessageRequestBody


class CreateTicketMessageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.ticket_id: Optional[str] = None
        self.request_body: Optional[CreateTicketMessageRequestBody] = None

    @staticmethod
    def builder() -> "CreateTicketMessageRequestBuilder":
        return CreateTicketMessageRequestBuilder()


class CreateTicketMessageRequestBuilder(object):

    def __init__(self) -> None:
        create_ticket_message_request = CreateTicketMessageRequest()
        create_ticket_message_request.http_method = HttpMethod.POST
        create_ticket_message_request.uri = "/open-apis/helpdesk/v1/tickets/:ticket_id/messages"
        create_ticket_message_request.token_types = {AccessTokenType.TENANT}
        self._create_ticket_message_request: CreateTicketMessageRequest = create_ticket_message_request

    def ticket_id(self, ticket_id: str) -> "CreateTicketMessageRequestBuilder":
        self._create_ticket_message_request.ticket_id = ticket_id
        self._create_ticket_message_request.paths["ticket_id"] = str(ticket_id)
        return self

    def request_body(self, request_body: CreateTicketMessageRequestBody) -> "CreateTicketMessageRequestBuilder":
        self._create_ticket_message_request.request_body = request_body
        self._create_ticket_message_request.body = request_body
        return self

    def build(self) -> CreateTicketMessageRequest:
        return self._create_ticket_message_request
