# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .ticket_customized_field import TicketCustomizedField
from .user_customized_field import UserCustomizedField


class CustomizedFieldsTicketResponseBody(object):
    _types = {
        "user_customized_fields": List[UserCustomizedField],
        "ticket_customized_fields": List[TicketCustomizedField],
    }

    def __init__(self, d=None):
        self.user_customized_fields: Optional[List[UserCustomizedField]] = None
        self.ticket_customized_fields: Optional[List[TicketCustomizedField]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CustomizedFieldsTicketResponseBodyBuilder":
        return CustomizedFieldsTicketResponseBodyBuilder()


class CustomizedFieldsTicketResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._customized_fields_ticket_response_body = CustomizedFieldsTicketResponseBody()

    def user_customized_fields(self, user_customized_fields: List[
        UserCustomizedField]) -> "CustomizedFieldsTicketResponseBodyBuilder":
        self._customized_fields_ticket_response_body.user_customized_fields = user_customized_fields
        return self

    def ticket_customized_fields(self, ticket_customized_fields: List[
        TicketCustomizedField]) -> "CustomizedFieldsTicketResponseBodyBuilder":
        self._customized_fields_ticket_response_body.ticket_customized_fields = ticket_customized_fields
        return self

    def build(self) -> "CustomizedFieldsTicketResponseBody":
        return self._customized_fields_ticket_response_body
