# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteFaqRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteFaqRequestBuilder":
        return DeleteFaqRequestBuilder()


class DeleteFaqRequestBuilder(object):

    def __init__(self) -> None:
        delete_faq_request = DeleteFaqRequest()
        delete_faq_request.http_method = HttpMethod.DELETE
        delete_faq_request.uri = "/open-apis/helpdesk/v1/faqs/:id"
        delete_faq_request.token_types = {AccessTokenType.USER}
        self._delete_faq_request: DeleteFaqRequest = delete_faq_request

    def id(self, id: str) -> "DeleteFaqRequestBuilder":
        self._delete_faq_request.id = id
        self._delete_faq_request.paths["id"] = str(id)
        return self

    def build(self) -> DeleteFaqRequest:
        return self._delete_faq_request
