# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .execute_send_notification_request_body import ExecuteSendNotificationRequestBody


class ExecuteSendNotificationRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.notification_id: Optional[str] = None
        self.request_body: Optional[ExecuteSendNotificationRequestBody] = None

    @staticmethod
    def builder() -> "ExecuteSendNotificationRequestBuilder":
        return ExecuteSendNotificationRequestBuilder()


class ExecuteSendNotificationRequestBuilder(object):

    def __init__(self) -> None:
        execute_send_notification_request = ExecuteSendNotificationRequest()
        execute_send_notification_request.http_method = HttpMethod.POST
        execute_send_notification_request.uri = "/open-apis/helpdesk/v1/notifications/:notification_id/execute_send"
        execute_send_notification_request.token_types = {AccessTokenType.USER}
        self._execute_send_notification_request: ExecuteSendNotificationRequest = execute_send_notification_request

    def notification_id(self, notification_id: str) -> "ExecuteSendNotificationRequestBuilder":
        self._execute_send_notification_request.notification_id = notification_id
        self._execute_send_notification_request.paths["notification_id"] = str(notification_id)
        return self

    def request_body(self, request_body: ExecuteSendNotificationRequestBody) -> "ExecuteSendNotificationRequestBuilder":
        self._execute_send_notification_request.request_body = request_body
        self._execute_send_notification_request.body = request_body
        return self

    def build(self) -> ExecuteSendNotificationRequest:
        return self._execute_send_notification_request
