# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class FaqImageFaqRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.id: Optional[str] = None
        self.image_key: Optional[str] = None

    @staticmethod
    def builder() -> "FaqImageFaqRequestBuilder":
        return FaqImageFaqRequestBuilder()


class FaqImageFaqRequestBuilder(object):

    def __init__(self) -> None:
        faq_image_faq_request = FaqImageFaqRequest()
        faq_image_faq_request.http_method = HttpMethod.GET
        faq_image_faq_request.uri = "/open-apis/helpdesk/v1/faqs/:id/image/:image_key"
        faq_image_faq_request.token_types = {AccessTokenType.TENANT}
        self._faq_image_faq_request: FaqImageFaqRequest = faq_image_faq_request

    def id(self, id: str) -> "FaqImageFaqRequestBuilder":
        self._faq_image_faq_request.id = id
        self._faq_image_faq_request.paths["id"] = str(id)
        return self

    def image_key(self, image_key: str) -> "FaqImageFaqRequestBuilder":
        self._faq_image_faq_request.image_key = image_key
        self._faq_image_faq_request.paths["image_key"] = str(image_key)
        return self

    def build(self) -> FaqImageFaqRequest:
        return self._faq_image_faq_request
