# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetTicketRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.ticket_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetTicketRequestBuilder":
        return GetTicketRequestBuilder()


class GetTicketRequestBuilder(object):

    def __init__(self) -> None:
        get_ticket_request = GetTicketRequest()
        get_ticket_request.http_method = HttpMethod.GET
        get_ticket_request.uri = "/open-apis/helpdesk/v1/tickets/:ticket_id"
        get_ticket_request.token_types = {AccessTokenType.TENANT}
        self._get_ticket_request: GetTicketRequest = get_ticket_request

    def ticket_id(self, ticket_id: str) -> "GetTicketRequestBuilder":
        self._get_ticket_request.ticket_id = ticket_id
        self._get_ticket_request.paths["ticket_id"] = str(ticket_id)
        return self

    def build(self) -> GetTicketRequest:
        return self._get_ticket_request
