# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListAgentScheduleRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.status: Optional[List[int]] = None

    @staticmethod
    def builder() -> "ListAgentScheduleRequestBuilder":
        return ListAgentScheduleRequestBuilder()


class ListAgentScheduleRequestBuilder(object):

    def __init__(self) -> None:
        list_agent_schedule_request = ListAgentScheduleRequest()
        list_agent_schedule_request.http_method = HttpMethod.GET
        list_agent_schedule_request.uri = "/open-apis/helpdesk/v1/agent_schedules"
        list_agent_schedule_request.token_types = {AccessTokenType.TENANT}
        self._list_agent_schedule_request: ListAgentScheduleRequest = list_agent_schedule_request

    def status(self, status: List[int]) -> "ListAgentScheduleRequestBuilder":
        self._list_agent_schedule_request.status = status
        self._list_agent_schedule_request.add_query("status", status)
        return self

    def build(self) -> ListAgentScheduleRequest:
        return self._list_agent_schedule_request
