# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListTicketMessageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.time_start: Optional[int] = None
        self.time_end: Optional[int] = None
        self.page: Optional[int] = None
        self.page_size: Optional[int] = None
        self.ticket_id: Optional[str] = None

    @staticmethod
    def builder() -> "ListTicketMessageRequestBuilder":
        return ListTicketMessageRequestBuilder()


class ListTicketMessageRequestBuilder(object):

    def __init__(self) -> None:
        list_ticket_message_request = ListTicketMessageRequest()
        list_ticket_message_request.http_method = HttpMethod.GET
        list_ticket_message_request.uri = "/open-apis/helpdesk/v1/tickets/:ticket_id/messages"
        list_ticket_message_request.token_types = {AccessTokenType.TENANT}
        self._list_ticket_message_request: ListTicketMessageRequest = list_ticket_message_request

    def time_start(self, time_start: int) -> "ListTicketMessageRequestBuilder":
        self._list_ticket_message_request.time_start = time_start
        self._list_ticket_message_request.add_query("time_start", time_start)
        return self

    def time_end(self, time_end: int) -> "ListTicketMessageRequestBuilder":
        self._list_ticket_message_request.time_end = time_end
        self._list_ticket_message_request.add_query("time_end", time_end)
        return self

    def page(self, page: int) -> "ListTicketMessageRequestBuilder":
        self._list_ticket_message_request.page = page
        self._list_ticket_message_request.add_query("page", page)
        return self

    def page_size(self, page_size: int) -> "ListTicketMessageRequestBuilder":
        self._list_ticket_message_request.page_size = page_size
        self._list_ticket_message_request.add_query("page_size", page_size)
        return self

    def ticket_id(self, ticket_id: str) -> "ListTicketMessageRequestBuilder":
        self._list_ticket_message_request.ticket_id = ticket_id
        self._list_ticket_message_request.paths["ticket_id"] = str(ticket_id)
        return self

    def build(self) -> ListTicketMessageRequest:
        return self._list_ticket_message_request
