# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .notification_chat import NotificationChat
from .notification_department import NotificationDepartment
from .notification_user import NotificationUser


class Notification(object):
    _types = {
        "id": str,
        "job_name": str,
        "status": int,
        "create_user": NotificationUser,
        "created_at": str,
        "update_user": NotificationUser,
        "updated_at": str,
        "target_user_count": int,
        "sent_user_count": int,
        "read_user_count": int,
        "send_at": str,
        "push_content": str,
        "push_type": int,
        "push_scope_type": int,
        "new_staff_scope_type": int,
        "new_staff_scope_department_list": List[NotificationDepartment],
        "user_list": List[NotificationUser],
        "department_list": List[NotificationDepartment],
        "chat_list": List[NotificationChat],
        "ext": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.job_name: Optional[str] = None
        self.status: Optional[int] = None
        self.create_user: Optional[NotificationUser] = None
        self.created_at: Optional[str] = None
        self.update_user: Optional[NotificationUser] = None
        self.updated_at: Optional[str] = None
        self.target_user_count: Optional[int] = None
        self.sent_user_count: Optional[int] = None
        self.read_user_count: Optional[int] = None
        self.send_at: Optional[str] = None
        self.push_content: Optional[str] = None
        self.push_type: Optional[int] = None
        self.push_scope_type: Optional[int] = None
        self.new_staff_scope_type: Optional[int] = None
        self.new_staff_scope_department_list: Optional[List[NotificationDepartment]] = None
        self.user_list: Optional[List[NotificationUser]] = None
        self.department_list: Optional[List[NotificationDepartment]] = None
        self.chat_list: Optional[List[NotificationChat]] = None
        self.ext: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "NotificationBuilder":
        return NotificationBuilder()


class NotificationBuilder(object):
    def __init__(self) -> None:
        self._notification = Notification()

    def id(self, id: str) -> "NotificationBuilder":
        self._notification.id = id
        return self

    def job_name(self, job_name: str) -> "NotificationBuilder":
        self._notification.job_name = job_name
        return self

    def status(self, status: int) -> "NotificationBuilder":
        self._notification.status = status
        return self

    def create_user(self, create_user: NotificationUser) -> "NotificationBuilder":
        self._notification.create_user = create_user
        return self

    def created_at(self, created_at: str) -> "NotificationBuilder":
        self._notification.created_at = created_at
        return self

    def update_user(self, update_user: NotificationUser) -> "NotificationBuilder":
        self._notification.update_user = update_user
        return self

    def updated_at(self, updated_at: str) -> "NotificationBuilder":
        self._notification.updated_at = updated_at
        return self

    def target_user_count(self, target_user_count: int) -> "NotificationBuilder":
        self._notification.target_user_count = target_user_count
        return self

    def sent_user_count(self, sent_user_count: int) -> "NotificationBuilder":
        self._notification.sent_user_count = sent_user_count
        return self

    def read_user_count(self, read_user_count: int) -> "NotificationBuilder":
        self._notification.read_user_count = read_user_count
        return self

    def send_at(self, send_at: str) -> "NotificationBuilder":
        self._notification.send_at = send_at
        return self

    def push_content(self, push_content: str) -> "NotificationBuilder":
        self._notification.push_content = push_content
        return self

    def push_type(self, push_type: int) -> "NotificationBuilder":
        self._notification.push_type = push_type
        return self

    def push_scope_type(self, push_scope_type: int) -> "NotificationBuilder":
        self._notification.push_scope_type = push_scope_type
        return self

    def new_staff_scope_type(self, new_staff_scope_type: int) -> "NotificationBuilder":
        self._notification.new_staff_scope_type = new_staff_scope_type
        return self

    def new_staff_scope_department_list(self, new_staff_scope_department_list: List[
        NotificationDepartment]) -> "NotificationBuilder":
        self._notification.new_staff_scope_department_list = new_staff_scope_department_list
        return self

    def user_list(self, user_list: List[NotificationUser]) -> "NotificationBuilder":
        self._notification.user_list = user_list
        return self

    def department_list(self, department_list: List[NotificationDepartment]) -> "NotificationBuilder":
        self._notification.department_list = department_list
        return self

    def chat_list(self, chat_list: List[NotificationChat]) -> "NotificationBuilder":
        self._notification.chat_list = chat_list
        return self

    def ext(self, ext: str) -> "NotificationBuilder":
        self._notification.ext = ext
        return self

    def build(self) -> "Notification":
        return self._notification
