# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class NotificationChat(object):
    _types = {
        "chat_id": str,
        "name": str,
    }

    def __init__(self, d=None):
        self.chat_id: Optional[str] = None
        self.name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "NotificationChatBuilder":
        return NotificationChatBuilder()


class NotificationChatBuilder(object):
    def __init__(self) -> None:
        self._notification_chat = NotificationChat()

    def chat_id(self, chat_id: str) -> "NotificationChatBuilder":
        self._notification_chat.chat_id = chat_id
        return self

    def name(self, name: str) -> "NotificationChatBuilder":
        self._notification_chat.name = name
        return self

    def build(self) -> "NotificationChat":
        return self._notification_chat
