# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class NotificationUser(object):
    _types = {
        "user_id": str,
        "avatar_url": str,
        "name": str,
    }

    def __init__(self, d=None):
        self.user_id: Optional[str] = None
        self.avatar_url: Optional[str] = None
        self.name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "NotificationUserBuilder":
        return NotificationUserBuilder()


class NotificationUserBuilder(object):
    def __init__(self) -> None:
        self._notification_user = NotificationUser()

    def user_id(self, user_id: str) -> "NotificationUserBuilder":
        self._notification_user.user_id = user_id
        return self

    def avatar_url(self, avatar_url: str) -> "NotificationUserBuilder":
        self._notification_user.avatar_url = avatar_url
        return self

    def name(self, name: str) -> "NotificationUserBuilder":
        self._notification_user.name = name
        return self

    def build(self) -> "NotificationUser":
        return self._notification_user
