# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .category import Category


class PatchCategoryRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.id: Optional[str] = None
        self.request_body: Optional[Category] = None

    @staticmethod
    def builder() -> "PatchCategoryRequestBuilder":
        return PatchCategoryRequestBuilder()


class PatchCategoryRequestBuilder(object):

    def __init__(self) -> None:
        patch_category_request = PatchCategoryRequest()
        patch_category_request.http_method = HttpMethod.PATCH
        patch_category_request.uri = "/open-apis/helpdesk/v1/categories/:id"
        patch_category_request.token_types = {AccessTokenType.USER}
        self._patch_category_request: PatchCategoryRequest = patch_category_request

    def id(self, id: str) -> "PatchCategoryRequestBuilder":
        self._patch_category_request.id = id
        self._patch_category_request.paths["id"] = str(id)
        return self

    def request_body(self, request_body: Category) -> "PatchCategoryRequestBuilder":
        self._patch_category_request.request_body = request_body
        self._patch_category_request.body = request_body
        return self

    def build(self) -> PatchCategoryRequest:
        return self._patch_category_request
