# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .notification import Notification


class PatchNotificationRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.notification_id: Optional[str] = None
        self.request_body: Optional[Notification] = None

    @staticmethod
    def builder() -> "PatchNotificationRequestBuilder":
        return PatchNotificationRequestBuilder()


class PatchNotificationRequestBuilder(object):

    def __init__(self) -> None:
        patch_notification_request = PatchNotificationRequest()
        patch_notification_request.http_method = HttpMethod.PATCH
        patch_notification_request.uri = "/open-apis/helpdesk/v1/notifications/:notification_id"
        patch_notification_request.token_types = {AccessTokenType.USER}
        self._patch_notification_request: PatchNotificationRequest = patch_notification_request

    def user_id_type(self, user_id_type: str) -> "PatchNotificationRequestBuilder":
        self._patch_notification_request.user_id_type = user_id_type
        self._patch_notification_request.add_query("user_id_type", user_id_type)
        return self

    def notification_id(self, notification_id: str) -> "PatchNotificationRequestBuilder":
        self._patch_notification_request.notification_id = notification_id
        self._patch_notification_request.paths["notification_id"] = str(notification_id)
        return self

    def request_body(self, request_body: Notification) -> "PatchNotificationRequestBuilder":
        self._patch_notification_request.request_body = request_body
        self._patch_notification_request.body = request_body
        return self

    def build(self) -> PatchNotificationRequest:
        return self._patch_notification_request
