# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class PreviewNotificationRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.notification_id: Optional[str] = None

    @staticmethod
    def builder() -> "PreviewNotificationRequestBuilder":
        return PreviewNotificationRequestBuilder()


class PreviewNotificationRequestBuilder(object):

    def __init__(self) -> None:
        preview_notification_request = PreviewNotificationRequest()
        preview_notification_request.http_method = HttpMethod.POST
        preview_notification_request.uri = "/open-apis/helpdesk/v1/notifications/:notification_id/preview"
        preview_notification_request.token_types = {AccessTokenType.USER}
        self._preview_notification_request: PreviewNotificationRequest = preview_notification_request

    def notification_id(self, notification_id: str) -> "PreviewNotificationRequestBuilder":
        self._preview_notification_request.notification_id = notification_id
        self._preview_notification_request.paths["notification_id"] = str(notification_id)
        return self

    def build(self) -> PreviewNotificationRequest:
        return self._preview_notification_request
