# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class SearchFaqRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.query: Optional[str] = None
        self.base64: Optional[str] = None
        self.page_token: Optional[str] = None
        self.page_size: Optional[int] = None

    @staticmethod
    def builder() -> "SearchFaqRequestBuilder":
        return SearchFaqRequestBuilder()


class SearchFaqRequestBuilder(object):

    def __init__(self) -> None:
        search_faq_request = SearchFaqRequest()
        search_faq_request.http_method = HttpMethod.GET
        search_faq_request.uri = "/open-apis/helpdesk/v1/faqs/search"
        search_faq_request.token_types = {AccessTokenType.TENANT}
        self._search_faq_request: SearchFaqRequest = search_faq_request

    def query(self, query: str) -> "SearchFaqRequestBuilder":
        self._search_faq_request.query = query
        self._search_faq_request.add_query("query", query)
        return self

    def base64(self, base64: str) -> "SearchFaqRequestBuilder":
        self._search_faq_request.base64 = base64
        self._search_faq_request.add_query("base64", base64)
        return self

    def page_token(self, page_token: str) -> "SearchFaqRequestBuilder":
        self._search_faq_request.page_token = page_token
        self._search_faq_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: int) -> "SearchFaqRequestBuilder":
        self._search_faq_request.page_size = page_size
        self._search_faq_request.add_query("page_size", page_size)
        return self

    def build(self) -> SearchFaqRequest:
        return self._search_faq_request
