# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class StartServiceTicketRequestBody(object):
    _types = {
        "human_service": bool,
        "appointed_agents": List[str],
        "open_id": str,
        "customized_info": str,
    }

    def __init__(self, d=None):
        self.human_service: Optional[bool] = None
        self.appointed_agents: Optional[List[str]] = None
        self.open_id: Optional[str] = None
        self.customized_info: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "StartServiceTicketRequestBodyBuilder":
        return StartServiceTicketRequestBodyBuilder()


class StartServiceTicketRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._start_service_ticket_request_body = StartServiceTicketRequestBody()

    def human_service(self, human_service: bool) -> "StartServiceTicketRequestBodyBuilder":
        self._start_service_ticket_request_body.human_service = human_service
        return self

    def appointed_agents(self, appointed_agents: List[str]) -> "StartServiceTicketRequestBodyBuilder":
        self._start_service_ticket_request_body.appointed_agents = appointed_agents
        return self

    def open_id(self, open_id: str) -> "StartServiceTicketRequestBodyBuilder":
        self._start_service_ticket_request_body.open_id = open_id
        return self

    def customized_info(self, customized_info: str) -> "StartServiceTicketRequestBodyBuilder":
        self._start_service_ticket_request_body.customized_info = customized_info
        return self

    def build(self) -> "StartServiceTicketRequestBody":
        return self._start_service_ticket_request_body
