# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .submit_approve_notification_request_body import SubmitApproveNotificationRequestBody


class SubmitApproveNotificationRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.notification_id: Optional[str] = None
        self.request_body: Optional[SubmitApproveNotificationRequestBody] = None

    @staticmethod
    def builder() -> "SubmitApproveNotificationRequestBuilder":
        return SubmitApproveNotificationRequestBuilder()


class SubmitApproveNotificationRequestBuilder(object):

    def __init__(self) -> None:
        submit_approve_notification_request = SubmitApproveNotificationRequest()
        submit_approve_notification_request.http_method = HttpMethod.POST
        submit_approve_notification_request.uri = "/open-apis/helpdesk/v1/notifications/:notification_id/submit_approve"
        submit_approve_notification_request.token_types = {AccessTokenType.USER}
        self._submit_approve_notification_request: SubmitApproveNotificationRequest = submit_approve_notification_request

    def notification_id(self, notification_id: str) -> "SubmitApproveNotificationRequestBuilder":
        self._submit_approve_notification_request.notification_id = notification_id
        self._submit_approve_notification_request.paths["notification_id"] = str(notification_id)
        return self

    def request_body(self,
                     request_body: SubmitApproveNotificationRequestBody) -> "SubmitApproveNotificationRequestBuilder":
        self._submit_approve_notification_request.request_body = request_body
        self._submit_approve_notification_request.body = request_body
        return self

    def build(self) -> SubmitApproveNotificationRequest:
        return self._submit_approve_notification_request
