# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .ticket_user import TicketUser


class TicketCustomizedField(object):
    _types = {
        "ticket_customized_field_id": str,
        "helpdesk_id": str,
        "key_name": str,
        "display_name": str,
        "position": str,
        "field_type": str,
        "description": str,
        "visible": bool,
        "editable": bool,
        "required": bool,
        "created_at": str,
        "updated_at": str,
        "created_by": TicketUser,
        "updated_by": TicketUser,
        "dropdown_allow_multiple": bool,
    }

    def __init__(self, d=None):
        self.ticket_customized_field_id: Optional[str] = None
        self.helpdesk_id: Optional[str] = None
        self.key_name: Optional[str] = None
        self.display_name: Optional[str] = None
        self.position: Optional[str] = None
        self.field_type: Optional[str] = None
        self.description: Optional[str] = None
        self.visible: Optional[bool] = None
        self.editable: Optional[bool] = None
        self.required: Optional[bool] = None
        self.created_at: Optional[str] = None
        self.updated_at: Optional[str] = None
        self.created_by: Optional[TicketUser] = None
        self.updated_by: Optional[TicketUser] = None
        self.dropdown_allow_multiple: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TicketCustomizedFieldBuilder":
        return TicketCustomizedFieldBuilder()


class TicketCustomizedFieldBuilder(object):
    def __init__(self) -> None:
        self._ticket_customized_field = TicketCustomizedField()

    def ticket_customized_field_id(self, ticket_customized_field_id: str) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.ticket_customized_field_id = ticket_customized_field_id
        return self

    def helpdesk_id(self, helpdesk_id: str) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.helpdesk_id = helpdesk_id
        return self

    def key_name(self, key_name: str) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.key_name = key_name
        return self

    def display_name(self, display_name: str) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.display_name = display_name
        return self

    def position(self, position: str) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.position = position
        return self

    def field_type(self, field_type: str) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.field_type = field_type
        return self

    def description(self, description: str) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.description = description
        return self

    def visible(self, visible: bool) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.visible = visible
        return self

    def editable(self, editable: bool) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.editable = editable
        return self

    def required(self, required: bool) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.required = required
        return self

    def created_at(self, created_at: str) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.created_at = created_at
        return self

    def updated_at(self, updated_at: str) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.updated_at = updated_at
        return self

    def created_by(self, created_by: TicketUser) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.created_by = created_by
        return self

    def updated_by(self, updated_by: TicketUser) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.updated_by = updated_by
        return self

    def dropdown_allow_multiple(self, dropdown_allow_multiple: bool) -> "TicketCustomizedFieldBuilder":
        self._ticket_customized_field.dropdown_allow_multiple = dropdown_allow_multiple
        return self

    def build(self) -> "TicketCustomizedField":
        return self._ticket_customized_field
