# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .user_id import UserId


class TicketUserEvent(object):
    _types = {
        "id": UserId,
        "avatar_url": str,
        "name": str,
        "email": str,
    }

    def __init__(self, d=None):
        self.id: Optional[UserId] = None
        self.avatar_url: Optional[str] = None
        self.name: Optional[str] = None
        self.email: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TicketUserEventBuilder":
        return TicketUserEventBuilder()


class TicketUserEventBuilder(object):
    def __init__(self) -> None:
        self._ticket_user_event = TicketUserEvent()

    def id(self, id: UserId) -> "TicketUserEventBuilder":
        self._ticket_user_event.id = id
        return self

    def avatar_url(self, avatar_url: str) -> "TicketUserEventBuilder":
        self._ticket_user_event.avatar_url = avatar_url
        return self

    def name(self, name: str) -> "TicketUserEventBuilder":
        self._ticket_user_event.name = name
        return self

    def email(self, email: str) -> "TicketUserEventBuilder":
        self._ticket_user_event.email = email
        return self

    def build(self) -> "TicketUserEvent":
        return self._ticket_user_event
