# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .unsubscribe_event_request_body import UnsubscribeEventRequestBody


class UnsubscribeEventRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[UnsubscribeEventRequestBody] = None

    @staticmethod
    def builder() -> "UnsubscribeEventRequestBuilder":
        return UnsubscribeEventRequestBuilder()


class UnsubscribeEventRequestBuilder(object):

    def __init__(self) -> None:
        unsubscribe_event_request = UnsubscribeEventRequest()
        unsubscribe_event_request.http_method = HttpMethod.POST
        unsubscribe_event_request.uri = "/open-apis/helpdesk/v1/events/unsubscribe"
        unsubscribe_event_request.token_types = {AccessTokenType.TENANT}
        self._unsubscribe_event_request: UnsubscribeEventRequest = unsubscribe_event_request

    def request_body(self, request_body: UnsubscribeEventRequestBody) -> "UnsubscribeEventRequestBuilder":
        self._unsubscribe_event_request.request_body = request_body
        self._unsubscribe_event_request.body = request_body
        return self

    def build(self) -> UnsubscribeEventRequest:
        return self._unsubscribe_event_request
