# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class UserCustomizedField(object):
    _types = {
        "user_customized_field_id": str,
        "id": str,
        "helpdesk_id": str,
        "key_name": str,
        "display_name": str,
        "position": str,
        "field_type": str,
        "description": str,
        "visible": bool,
        "editable": bool,
        "required": bool,
        "created_at": str,
        "updated_at": str,
    }

    def __init__(self, d=None):
        self.user_customized_field_id: Optional[str] = None
        self.id: Optional[str] = None
        self.helpdesk_id: Optional[str] = None
        self.key_name: Optional[str] = None
        self.display_name: Optional[str] = None
        self.position: Optional[str] = None
        self.field_type: Optional[str] = None
        self.description: Optional[str] = None
        self.visible: Optional[bool] = None
        self.editable: Optional[bool] = None
        self.required: Optional[bool] = None
        self.created_at: Optional[str] = None
        self.updated_at: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UserCustomizedFieldBuilder":
        return UserCustomizedFieldBuilder()


class UserCustomizedFieldBuilder(object):
    def __init__(self) -> None:
        self._user_customized_field = UserCustomizedField()

    def user_customized_field_id(self, user_customized_field_id: str) -> "UserCustomizedFieldBuilder":
        self._user_customized_field.user_customized_field_id = user_customized_field_id
        return self

    def id(self, id: str) -> "UserCustomizedFieldBuilder":
        self._user_customized_field.id = id
        return self

    def helpdesk_id(self, helpdesk_id: str) -> "UserCustomizedFieldBuilder":
        self._user_customized_field.helpdesk_id = helpdesk_id
        return self

    def key_name(self, key_name: str) -> "UserCustomizedFieldBuilder":
        self._user_customized_field.key_name = key_name
        return self

    def display_name(self, display_name: str) -> "UserCustomizedFieldBuilder":
        self._user_customized_field.display_name = display_name
        return self

    def position(self, position: str) -> "UserCustomizedFieldBuilder":
        self._user_customized_field.position = position
        return self

    def field_type(self, field_type: str) -> "UserCustomizedFieldBuilder":
        self._user_customized_field.field_type = field_type
        return self

    def description(self, description: str) -> "UserCustomizedFieldBuilder":
        self._user_customized_field.description = description
        return self

    def visible(self, visible: bool) -> "UserCustomizedFieldBuilder":
        self._user_customized_field.visible = visible
        return self

    def editable(self, editable: bool) -> "UserCustomizedFieldBuilder":
        self._user_customized_field.editable = editable
        return self

    def required(self, required: bool) -> "UserCustomizedFieldBuilder":
        self._user_customized_field.required = required
        return self

    def created_at(self, created_at: str) -> "UserCustomizedFieldBuilder":
        self._user_customized_field.created_at = created_at
        return self

    def updated_at(self, updated_at: str) -> "UserCustomizedFieldBuilder":
        self._user_customized_field.updated_at = updated_at
        return self

    def build(self) -> "UserCustomizedField":
        return self._user_customized_field
