# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.agent_email_agent_request import AgentEmailAgentRequest
from ..model.agent_email_agent_response import AgentEmailAgentResponse
from ..model.patch_agent_request import PatchAgentRequest
from ..model.patch_agent_response import PatchAgentResponse


class Agent(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def agent_email(self, request: AgentEmailAgentRequest,
                    option: Optional[RequestOption] = None) -> AgentEmailAgentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: AgentEmailAgentResponse = JSON.unmarshal(str(resp.content, UTF_8), AgentEmailAgentResponse)
        response.raw = resp

        return response

    async def aagent_email(self, request: AgentEmailAgentRequest,
                           option: Optional[RequestOption] = None) -> AgentEmailAgentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: AgentEmailAgentResponse = JSON.unmarshal(str(resp.content, UTF_8), AgentEmailAgentResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchAgentRequest, option: Optional[RequestOption] = None) -> PatchAgentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchAgentResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchAgentResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchAgentRequest, option: Optional[RequestOption] = None) -> PatchAgentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchAgentResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchAgentResponse)
        response.raw = resp

        return response
