# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_category_request import CreateCategoryRequest
from ..model.create_category_response import CreateCategoryResponse
from ..model.delete_category_request import DeleteCategoryRequest
from ..model.delete_category_response import DeleteCategoryResponse
from ..model.get_category_request import GetCategoryRequest
from ..model.get_category_response import GetCategoryResponse
from ..model.list_category_request import ListCategoryRequest
from ..model.list_category_response import ListCategoryResponse
from ..model.patch_category_request import PatchCategoryRequest
from ..model.patch_category_response import PatchCategoryResponse


class Category(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateCategoryRequest, option: Optional[RequestOption] = None) -> CreateCategoryResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateCategoryResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateCategoryResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateCategoryRequest,
                      option: Optional[RequestOption] = None) -> CreateCategoryResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateCategoryResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateCategoryResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteCategoryRequest, option: Optional[RequestOption] = None) -> DeleteCategoryResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteCategoryResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteCategoryResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteCategoryRequest,
                      option: Optional[RequestOption] = None) -> DeleteCategoryResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteCategoryResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteCategoryResponse)
        response.raw = resp

        return response

    def get(self, request: GetCategoryRequest, option: Optional[RequestOption] = None) -> GetCategoryResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetCategoryResponse = JSON.unmarshal(str(resp.content, UTF_8), GetCategoryResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetCategoryRequest, option: Optional[RequestOption] = None) -> GetCategoryResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetCategoryResponse = JSON.unmarshal(str(resp.content, UTF_8), GetCategoryResponse)
        response.raw = resp

        return response

    def list(self, request: ListCategoryRequest, option: Optional[RequestOption] = None) -> ListCategoryResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListCategoryResponse = JSON.unmarshal(str(resp.content, UTF_8), ListCategoryResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListCategoryRequest, option: Optional[RequestOption] = None) -> ListCategoryResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListCategoryResponse = JSON.unmarshal(str(resp.content, UTF_8), ListCategoryResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchCategoryRequest, option: Optional[RequestOption] = None) -> PatchCategoryResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchCategoryResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchCategoryResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchCategoryRequest,
                     option: Optional[RequestOption] = None) -> PatchCategoryResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchCategoryResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchCategoryResponse)
        response.raw = resp

        return response
