# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.subscribe_event_request import SubscribeEventRequest
from ..model.subscribe_event_response import SubscribeEventResponse
from ..model.unsubscribe_event_request import UnsubscribeEventRequest
from ..model.unsubscribe_event_response import UnsubscribeEventResponse


class Event(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def subscribe(self, request: SubscribeEventRequest,
                  option: Optional[RequestOption] = None) -> SubscribeEventResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SubscribeEventResponse = JSON.unmarshal(str(resp.content, UTF_8), SubscribeEventResponse)
        response.raw = resp

        return response

    async def asubscribe(self, request: SubscribeEventRequest,
                         option: Optional[RequestOption] = None) -> SubscribeEventResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SubscribeEventResponse = JSON.unmarshal(str(resp.content, UTF_8), SubscribeEventResponse)
        response.raw = resp

        return response

    def unsubscribe(self, request: UnsubscribeEventRequest,
                    option: Optional[RequestOption] = None) -> UnsubscribeEventResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UnsubscribeEventResponse = JSON.unmarshal(str(resp.content, UTF_8), UnsubscribeEventResponse)
        response.raw = resp

        return response

    async def aunsubscribe(self, request: UnsubscribeEventRequest,
                           option: Optional[RequestOption] = None) -> UnsubscribeEventResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UnsubscribeEventResponse = JSON.unmarshal(str(resp.content, UTF_8), UnsubscribeEventResponse)
        response.raw = resp

        return response
