# Code generated by Lark OpenAPI.

import io
from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from lark_oapi.core.utils import Files
from ..model.answer_user_query_ticket_request import AnswerUserQueryTicketRequest
from ..model.answer_user_query_ticket_response import AnswerUserQueryTicketResponse
from ..model.customized_fields_ticket_request import CustomizedFieldsTicketRequest
from ..model.customized_fields_ticket_response import CustomizedFieldsTicketResponse
from ..model.get_ticket_request import GetTicketRequest
from ..model.get_ticket_response import GetTicketResponse
from ..model.list_ticket_request import ListTicketRequest
from ..model.list_ticket_response import ListTicketResponse
from ..model.start_service_ticket_request import StartServiceTicketRequest
from ..model.start_service_ticket_response import StartServiceTicketResponse
from ..model.ticket_image_ticket_request import TicketImageTicketRequest
from ..model.ticket_image_ticket_response import TicketImageTicketResponse
from ..model.update_ticket_request import UpdateTicketRequest
from ..model.update_ticket_response import UpdateTicketResponse


class Ticket(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def answer_user_query(self, request: AnswerUserQueryTicketRequest,
                          option: Optional[RequestOption] = None) -> AnswerUserQueryTicketResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: AnswerUserQueryTicketResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                 AnswerUserQueryTicketResponse)
        response.raw = resp

        return response

    async def aanswer_user_query(self, request: AnswerUserQueryTicketRequest,
                                 option: Optional[RequestOption] = None) -> AnswerUserQueryTicketResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: AnswerUserQueryTicketResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                 AnswerUserQueryTicketResponse)
        response.raw = resp

        return response

    def customized_fields(self, request: CustomizedFieldsTicketRequest,
                          option: Optional[RequestOption] = None) -> CustomizedFieldsTicketResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CustomizedFieldsTicketResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  CustomizedFieldsTicketResponse)
        response.raw = resp

        return response

    async def acustomized_fields(self, request: CustomizedFieldsTicketRequest,
                                 option: Optional[RequestOption] = None) -> CustomizedFieldsTicketResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CustomizedFieldsTicketResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  CustomizedFieldsTicketResponse)
        response.raw = resp

        return response

    def get(self, request: GetTicketRequest, option: Optional[RequestOption] = None) -> GetTicketResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetTicketResponse = JSON.unmarshal(str(resp.content, UTF_8), GetTicketResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetTicketRequest, option: Optional[RequestOption] = None) -> GetTicketResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetTicketResponse = JSON.unmarshal(str(resp.content, UTF_8), GetTicketResponse)
        response.raw = resp

        return response

    def list(self, request: ListTicketRequest, option: Optional[RequestOption] = None) -> ListTicketResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListTicketResponse = JSON.unmarshal(str(resp.content, UTF_8), ListTicketResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListTicketRequest, option: Optional[RequestOption] = None) -> ListTicketResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListTicketResponse = JSON.unmarshal(str(resp.content, UTF_8), ListTicketResponse)
        response.raw = resp

        return response

    def start_service(self, request: StartServiceTicketRequest,
                      option: Optional[RequestOption] = None) -> StartServiceTicketResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: StartServiceTicketResponse = JSON.unmarshal(str(resp.content, UTF_8), StartServiceTicketResponse)
        response.raw = resp

        return response

    async def astart_service(self, request: StartServiceTicketRequest,
                             option: Optional[RequestOption] = None) -> StartServiceTicketResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: StartServiceTicketResponse = JSON.unmarshal(str(resp.content, UTF_8), StartServiceTicketResponse)
        response.raw = resp

        return response

    def ticket_image(self, request: TicketImageTicketRequest,
                     option: Optional[RequestOption] = None) -> TicketImageTicketResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 处理二进制流
        content_type = resp.headers.get(CONTENT_TYPE)
        response: TicketImageTicketResponse = TicketImageTicketResponse()
        if 200 <= resp.status_code < 300:
            response.code = 0
            response.file = io.BytesIO(resp.content)
            response.file_name = Files.parse_file_name(resp.headers)
        elif content_type is not None and content_type.startswith(APPLICATION_JSON):
            response = JSON.unmarshal(str(resp.content, UTF_8), TicketImageTicketResponse)

        response.raw = resp
        return response

    async def aticket_image(self, request: TicketImageTicketRequest,
                            option: Optional[RequestOption] = None) -> TicketImageTicketResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 处理二进制流
        content_type = resp.headers.get(CONTENT_TYPE)
        response: TicketImageTicketResponse = TicketImageTicketResponse()
        if 200 <= resp.status_code < 300:
            response.code = 0
            response.file = io.BytesIO(resp.content)
            response.file_name = Files.parse_file_name(resp.headers)
        elif content_type is not None and content_type.startswith(APPLICATION_JSON):
            response = JSON.unmarshal(str(resp.content, UTF_8), TicketImageTicketResponse)

        response.raw = resp
        return response

    def update(self, request: UpdateTicketRequest, option: Optional[RequestOption] = None) -> UpdateTicketResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UpdateTicketResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateTicketResponse)
        response.raw = resp

        return response

    async def aupdate(self, request: UpdateTicketRequest,
                      option: Optional[RequestOption] = None) -> UpdateTicketResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UpdateTicketResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateTicketResponse)
        response.raw = resp

        return response
