# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n import I18n


class Ability(object):
    _types = {
        "id": str,
        "name": I18n,
        "description": I18n,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[I18n] = None
        self.description: Optional[I18n] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AbilityBuilder":
        return AbilityBuilder()


class AbilityBuilder(object):
    def __init__(self) -> None:
        self._ability = Ability()

    def id(self, id: str) -> "AbilityBuilder":
        self._ability.id = id
        return self

    def name(self, name: I18n) -> "AbilityBuilder":
        self._ability.name = name
        return self

    def description(self, description: I18n) -> "AbilityBuilder":
        self._ability.description = description
        return self

    def build(self) -> "Ability":
        return self._ability
