# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .assets import Assets


class Account(object):
    _types = {
        "account_id": str,
        "assets": Assets,
        "status": int,
    }

    def __init__(self, d=None):
        self.account_id: Optional[str] = None
        self.assets: Optional[Assets] = None
        self.status: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AccountBuilder":
        return AccountBuilder()


class AccountBuilder(object):
    def __init__(self) -> None:
        self._account = Account()

    def account_id(self, account_id: str) -> "AccountBuilder":
        self._account.account_id = account_id
        return self

    def assets(self, assets: Assets) -> "AccountBuilder":
        self._account.assets = assets
        return self

    def status(self, status: int) -> "AccountBuilder":
        self._account.status = status
        return self

    def build(self) -> "Account":
        return self._account
