# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .add_to_folder_talent_request_body import AddToFolderTalentRequestBody


class AddToFolderTalentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[AddToFolderTalentRequestBody] = None

    @staticmethod
    def builder() -> "AddToFolderTalentRequestBuilder":
        return AddToFolderTalentRequestBuilder()


class AddToFolderTalentRequestBuilder(object):

    def __init__(self) -> None:
        add_to_folder_talent_request = AddToFolderTalentRequest()
        add_to_folder_talent_request.http_method = HttpMethod.POST
        add_to_folder_talent_request.uri = "/open-apis/hire/v1/talents/add_to_folder"
        add_to_folder_talent_request.token_types = {AccessTokenType.TENANT}
        self._add_to_folder_talent_request: AddToFolderTalentRequest = add_to_folder_talent_request

    def request_body(self, request_body: AddToFolderTalentRequestBody) -> "AddToFolderTalentRequestBuilder":
        self._add_to_folder_talent_request.request_body = request_body
        self._add_to_folder_talent_request.body = request_body
        return self

    def build(self) -> AddToFolderTalentRequest:
        return self._add_to_folder_talent_request
