# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n import I18n


class AgencyProtection(object):
    _types = {
        "protection_type": int,
        "application_id": str,
        "start_time": str,
        "expire_time": str,
        "agency_supplier_id": str,
        "agency_supplier_name": I18n,
        "agency_supplier_user_id": str,
        "agency_supplier_user_name": I18n,
    }

    def __init__(self, d=None):
        self.protection_type: Optional[int] = None
        self.application_id: Optional[str] = None
        self.start_time: Optional[str] = None
        self.expire_time: Optional[str] = None
        self.agency_supplier_id: Optional[str] = None
        self.agency_supplier_name: Optional[I18n] = None
        self.agency_supplier_user_id: Optional[str] = None
        self.agency_supplier_user_name: Optional[I18n] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AgencyProtectionBuilder":
        return AgencyProtectionBuilder()


class AgencyProtectionBuilder(object):
    def __init__(self) -> None:
        self._agency_protection = AgencyProtection()

    def protection_type(self, protection_type: int) -> "AgencyProtectionBuilder":
        self._agency_protection.protection_type = protection_type
        return self

    def application_id(self, application_id: str) -> "AgencyProtectionBuilder":
        self._agency_protection.application_id = application_id
        return self

    def start_time(self, start_time: str) -> "AgencyProtectionBuilder":
        self._agency_protection.start_time = start_time
        return self

    def expire_time(self, expire_time: str) -> "AgencyProtectionBuilder":
        self._agency_protection.expire_time = expire_time
        return self

    def agency_supplier_id(self, agency_supplier_id: str) -> "AgencyProtectionBuilder":
        self._agency_protection.agency_supplier_id = agency_supplier_id
        return self

    def agency_supplier_name(self, agency_supplier_name: I18n) -> "AgencyProtectionBuilder":
        self._agency_protection.agency_supplier_name = agency_supplier_name
        return self

    def agency_supplier_user_id(self, agency_supplier_user_id: str) -> "AgencyProtectionBuilder":
        self._agency_protection.agency_supplier_user_id = agency_supplier_user_id
        return self

    def agency_supplier_user_name(self, agency_supplier_user_name: I18n) -> "AgencyProtectionBuilder":
        self._agency_protection.agency_supplier_user_name = agency_supplier_user_name
        return self

    def build(self) -> "AgencyProtection":
        return self._agency_protection
