# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .application_resume_source import ApplicationResumeSource
from .application_stage_info import ApplicationStageInfo
from .application_stage_time import ApplicationStageTime
from .application_website_resume_source import ApplicationWebsiteResumeSource
from .code_name_object import CodeNameObject


class Application(object):
    _types = {
        "id": str,
        "job_id": str,
        "talent_id": str,
        "resume_source_id": str,
        "stage": ApplicationStageInfo,
        "active_status": int,
        "delivery_type": int,
        "resume_source_info": ApplicationResumeSource,
        "website_resume_source": ApplicationWebsiteResumeSource,
        "talent_attachment_resume_id": str,
        "create_time": str,
        "modify_time": str,
        "stage_time_list": List[ApplicationStageTime],
        "termination_type": int,
        "termination_reason_list": List[str],
        "termination_reason_note": str,
        "application_preferred_city_list": List[CodeNameObject],
        "creator_id": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.job_id: Optional[str] = None
        self.talent_id: Optional[str] = None
        self.resume_source_id: Optional[str] = None
        self.stage: Optional[ApplicationStageInfo] = None
        self.active_status: Optional[int] = None
        self.delivery_type: Optional[int] = None
        self.resume_source_info: Optional[ApplicationResumeSource] = None
        self.website_resume_source: Optional[ApplicationWebsiteResumeSource] = None
        self.talent_attachment_resume_id: Optional[str] = None
        self.create_time: Optional[str] = None
        self.modify_time: Optional[str] = None
        self.stage_time_list: Optional[List[ApplicationStageTime]] = None
        self.termination_type: Optional[int] = None
        self.termination_reason_list: Optional[List[str]] = None
        self.termination_reason_note: Optional[str] = None
        self.application_preferred_city_list: Optional[List[CodeNameObject]] = None
        self.creator_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ApplicationBuilder":
        return ApplicationBuilder()


class ApplicationBuilder(object):
    def __init__(self) -> None:
        self._application = Application()

    def id(self, id: str) -> "ApplicationBuilder":
        self._application.id = id
        return self

    def job_id(self, job_id: str) -> "ApplicationBuilder":
        self._application.job_id = job_id
        return self

    def talent_id(self, talent_id: str) -> "ApplicationBuilder":
        self._application.talent_id = talent_id
        return self

    def resume_source_id(self, resume_source_id: str) -> "ApplicationBuilder":
        self._application.resume_source_id = resume_source_id
        return self

    def stage(self, stage: ApplicationStageInfo) -> "ApplicationBuilder":
        self._application.stage = stage
        return self

    def active_status(self, active_status: int) -> "ApplicationBuilder":
        self._application.active_status = active_status
        return self

    def delivery_type(self, delivery_type: int) -> "ApplicationBuilder":
        self._application.delivery_type = delivery_type
        return self

    def resume_source_info(self, resume_source_info: ApplicationResumeSource) -> "ApplicationBuilder":
        self._application.resume_source_info = resume_source_info
        return self

    def website_resume_source(self, website_resume_source: ApplicationWebsiteResumeSource) -> "ApplicationBuilder":
        self._application.website_resume_source = website_resume_source
        return self

    def talent_attachment_resume_id(self, talent_attachment_resume_id: str) -> "ApplicationBuilder":
        self._application.talent_attachment_resume_id = talent_attachment_resume_id
        return self

    def create_time(self, create_time: str) -> "ApplicationBuilder":
        self._application.create_time = create_time
        return self

    def modify_time(self, modify_time: str) -> "ApplicationBuilder":
        self._application.modify_time = modify_time
        return self

    def stage_time_list(self, stage_time_list: List[ApplicationStageTime]) -> "ApplicationBuilder":
        self._application.stage_time_list = stage_time_list
        return self

    def termination_type(self, termination_type: int) -> "ApplicationBuilder":
        self._application.termination_type = termination_type
        return self

    def termination_reason_list(self, termination_reason_list: List[str]) -> "ApplicationBuilder":
        self._application.termination_reason_list = termination_reason_list
        return self

    def termination_reason_note(self, termination_reason_note: str) -> "ApplicationBuilder":
        self._application.termination_reason_note = termination_reason_note
        return self

    def application_preferred_city_list(self,
                                        application_preferred_city_list: List[CodeNameObject]) -> "ApplicationBuilder":
        self._application.application_preferred_city_list = application_preferred_city_list
        return self

    def creator_id(self, creator_id: str) -> "ApplicationBuilder":
        self._application.creator_id = creator_id
        return self

    def build(self) -> "Application":
        return self._application
