# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .application_offer_onboard_profile_city import ApplicationOfferOnboardProfileCity


class ApplicationOfferOnboardProfileAddress(object):
    _types = {
        "id": str,
        "name": str,
        "en_name": str,
        "district": ApplicationOfferOnboardProfileCity,
        "city": ApplicationOfferOnboardProfileCity,
        "state": ApplicationOfferOnboardProfileCity,
        "country": ApplicationOfferOnboardProfileCity,
        "usage_id_list": List[str],
        "active_status": int,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.en_name: Optional[str] = None
        self.district: Optional[ApplicationOfferOnboardProfileCity] = None
        self.city: Optional[ApplicationOfferOnboardProfileCity] = None
        self.state: Optional[ApplicationOfferOnboardProfileCity] = None
        self.country: Optional[ApplicationOfferOnboardProfileCity] = None
        self.usage_id_list: Optional[List[str]] = None
        self.active_status: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ApplicationOfferOnboardProfileAddressBuilder":
        return ApplicationOfferOnboardProfileAddressBuilder()


class ApplicationOfferOnboardProfileAddressBuilder(object):
    def __init__(self) -> None:
        self._application_offer_onboard_profile_address = ApplicationOfferOnboardProfileAddress()

    def id(self, id: str) -> "ApplicationOfferOnboardProfileAddressBuilder":
        self._application_offer_onboard_profile_address.id = id
        return self

    def name(self, name: str) -> "ApplicationOfferOnboardProfileAddressBuilder":
        self._application_offer_onboard_profile_address.name = name
        return self

    def en_name(self, en_name: str) -> "ApplicationOfferOnboardProfileAddressBuilder":
        self._application_offer_onboard_profile_address.en_name = en_name
        return self

    def district(self, district: ApplicationOfferOnboardProfileCity) -> "ApplicationOfferOnboardProfileAddressBuilder":
        self._application_offer_onboard_profile_address.district = district
        return self

    def city(self, city: ApplicationOfferOnboardProfileCity) -> "ApplicationOfferOnboardProfileAddressBuilder":
        self._application_offer_onboard_profile_address.city = city
        return self

    def state(self, state: ApplicationOfferOnboardProfileCity) -> "ApplicationOfferOnboardProfileAddressBuilder":
        self._application_offer_onboard_profile_address.state = state
        return self

    def country(self, country: ApplicationOfferOnboardProfileCity) -> "ApplicationOfferOnboardProfileAddressBuilder":
        self._application_offer_onboard_profile_address.country = country
        return self

    def usage_id_list(self, usage_id_list: List[str]) -> "ApplicationOfferOnboardProfileAddressBuilder":
        self._application_offer_onboard_profile_address.usage_id_list = usage_id_list
        return self

    def active_status(self, active_status: int) -> "ApplicationOfferOnboardProfileAddressBuilder":
        self._application_offer_onboard_profile_address.active_status = active_status
        return self

    def build(self) -> "ApplicationOfferOnboardProfileAddress":
        return self._application_offer_onboard_profile_address
