# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .application_offer_custom_value import ApplicationOfferCustomValue


class ApplicationOfferSalaryPlan(object):
    _types = {
        "currency": str,
        "basic_salary": str,
        "probation_salary_percentage": str,
        "award_salary_multiple": str,
        "option_shares": str,
        "quarterly_bonus": str,
        "half_year_bonus": str,
        "total_annual_cash": str,
        "customize_info_list": List[ApplicationOfferCustomValue],
    }

    def __init__(self, d=None):
        self.currency: Optional[str] = None
        self.basic_salary: Optional[str] = None
        self.probation_salary_percentage: Optional[str] = None
        self.award_salary_multiple: Optional[str] = None
        self.option_shares: Optional[str] = None
        self.quarterly_bonus: Optional[str] = None
        self.half_year_bonus: Optional[str] = None
        self.total_annual_cash: Optional[str] = None
        self.customize_info_list: Optional[List[ApplicationOfferCustomValue]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ApplicationOfferSalaryPlanBuilder":
        return ApplicationOfferSalaryPlanBuilder()


class ApplicationOfferSalaryPlanBuilder(object):
    def __init__(self) -> None:
        self._application_offer_salary_plan = ApplicationOfferSalaryPlan()

    def currency(self, currency: str) -> "ApplicationOfferSalaryPlanBuilder":
        self._application_offer_salary_plan.currency = currency
        return self

    def basic_salary(self, basic_salary: str) -> "ApplicationOfferSalaryPlanBuilder":
        self._application_offer_salary_plan.basic_salary = basic_salary
        return self

    def probation_salary_percentage(self, probation_salary_percentage: str) -> "ApplicationOfferSalaryPlanBuilder":
        self._application_offer_salary_plan.probation_salary_percentage = probation_salary_percentage
        return self

    def award_salary_multiple(self, award_salary_multiple: str) -> "ApplicationOfferSalaryPlanBuilder":
        self._application_offer_salary_plan.award_salary_multiple = award_salary_multiple
        return self

    def option_shares(self, option_shares: str) -> "ApplicationOfferSalaryPlanBuilder":
        self._application_offer_salary_plan.option_shares = option_shares
        return self

    def quarterly_bonus(self, quarterly_bonus: str) -> "ApplicationOfferSalaryPlanBuilder":
        self._application_offer_salary_plan.quarterly_bonus = quarterly_bonus
        return self

    def half_year_bonus(self, half_year_bonus: str) -> "ApplicationOfferSalaryPlanBuilder":
        self._application_offer_salary_plan.half_year_bonus = half_year_bonus
        return self

    def total_annual_cash(self, total_annual_cash: str) -> "ApplicationOfferSalaryPlanBuilder":
        self._application_offer_salary_plan.total_annual_cash = total_annual_cash
        return self

    def customize_info_list(self, customize_info_list: List[
        ApplicationOfferCustomValue]) -> "ApplicationOfferSalaryPlanBuilder":
        self._application_offer_salary_plan.customize_info_list = customize_info_list
        return self

    def build(self) -> "ApplicationOfferSalaryPlan":
        return self._application_offer_salary_plan
