# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ApplicationStage(object):
    _types = {
        "id": str,
        "name": str,
        "en_name": str,
        "type": int,
        "args": str,
        "creator_id": str,
        "seq": int,
        "publish_name": str,
        "publish_en_name": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.en_name: Optional[str] = None
        self.type: Optional[int] = None
        self.args: Optional[str] = None
        self.creator_id: Optional[str] = None
        self.seq: Optional[int] = None
        self.publish_name: Optional[str] = None
        self.publish_en_name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ApplicationStageBuilder":
        return ApplicationStageBuilder()


class ApplicationStageBuilder(object):
    def __init__(self) -> None:
        self._application_stage = ApplicationStage()

    def id(self, id: str) -> "ApplicationStageBuilder":
        self._application_stage.id = id
        return self

    def name(self, name: str) -> "ApplicationStageBuilder":
        self._application_stage.name = name
        return self

    def en_name(self, en_name: str) -> "ApplicationStageBuilder":
        self._application_stage.en_name = en_name
        return self

    def type(self, type: int) -> "ApplicationStageBuilder":
        self._application_stage.type = type
        return self

    def args(self, args: str) -> "ApplicationStageBuilder":
        self._application_stage.args = args
        return self

    def creator_id(self, creator_id: str) -> "ApplicationStageBuilder":
        self._application_stage.creator_id = creator_id
        return self

    def seq(self, seq: int) -> "ApplicationStageBuilder":
        self._application_stage.seq = seq
        return self

    def publish_name(self, publish_name: str) -> "ApplicationStageBuilder":
        self._application_stage.publish_name = publish_name
        return self

    def publish_en_name(self, publish_en_name: str) -> "ApplicationStageBuilder":
        self._application_stage.publish_en_name = publish_en_name
        return self

    def build(self) -> "ApplicationStage":
        return self._application_stage
