# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n import I18n


class ApplicationWebsiteChannel(object):
    _types = {
        "channel_id": str,
        "channel_name": I18n,
    }

    def __init__(self, d=None):
        self.channel_id: Optional[str] = None
        self.channel_name: Optional[I18n] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ApplicationWebsiteChannelBuilder":
        return ApplicationWebsiteChannelBuilder()


class ApplicationWebsiteChannelBuilder(object):
    def __init__(self) -> None:
        self._application_website_channel = ApplicationWebsiteChannel()

    def channel_id(self, channel_id: str) -> "ApplicationWebsiteChannelBuilder":
        self._application_website_channel.channel_id = channel_id
        return self

    def channel_name(self, channel_name: I18n) -> "ApplicationWebsiteChannelBuilder":
        self._application_website_channel.channel_name = channel_name
        return self

    def build(self) -> "ApplicationWebsiteChannel":
        return self._application_website_channel
