# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .application_website_channel import ApplicationWebsiteChannel
from .i18n import I18n


class ApplicationWebsiteResumeSource(object):
    _types = {
        "website_id": str,
        "website_name": I18n,
        "channel": ApplicationWebsiteChannel,
    }

    def __init__(self, d=None):
        self.website_id: Optional[str] = None
        self.website_name: Optional[I18n] = None
        self.channel: Optional[ApplicationWebsiteChannel] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ApplicationWebsiteResumeSourceBuilder":
        return ApplicationWebsiteResumeSourceBuilder()


class ApplicationWebsiteResumeSourceBuilder(object):
    def __init__(self) -> None:
        self._application_website_resume_source = ApplicationWebsiteResumeSource()

    def website_id(self, website_id: str) -> "ApplicationWebsiteResumeSourceBuilder":
        self._application_website_resume_source.website_id = website_id
        return self

    def website_name(self, website_name: I18n) -> "ApplicationWebsiteResumeSourceBuilder":
        self._application_website_resume_source.website_name = website_name
        return self

    def channel(self, channel: ApplicationWebsiteChannel) -> "ApplicationWebsiteResumeSourceBuilder":
        self._application_website_resume_source.channel = channel
        return self

    def build(self) -> "ApplicationWebsiteResumeSource":
        return self._application_website_resume_source
