# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class AssessmentScoreInfo(object):
    _types = {
        "calculate_type": int,
        "score": float,
        "full_score": int,
    }

    def __init__(self, d=None):
        self.calculate_type: Optional[int] = None
        self.score: Optional[float] = None
        self.full_score: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AssessmentScoreInfoBuilder":
        return AssessmentScoreInfoBuilder()


class AssessmentScoreInfoBuilder(object):
    def __init__(self) -> None:
        self._assessment_score_info = AssessmentScoreInfo()

    def calculate_type(self, calculate_type: int) -> "AssessmentScoreInfoBuilder":
        self._assessment_score_info.calculate_type = calculate_type
        return self

    def score(self, score: float) -> "AssessmentScoreInfoBuilder":
        self._assessment_score_info.score = score
        return self

    def full_score(self, full_score: int) -> "AssessmentScoreInfoBuilder":
        self._assessment_score_info.full_score = full_score
        return self

    def build(self) -> "AssessmentScoreInfo":
        return self._assessment_score_info
