# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class AttachmentInfo(object):
    _types = {
        "id": str,
        "url": str,
        "name": str,
        "mime": str,
        "create_time": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.url: Optional[str] = None
        self.name: Optional[str] = None
        self.mime: Optional[str] = None
        self.create_time: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AttachmentInfoBuilder":
        return AttachmentInfoBuilder()


class AttachmentInfoBuilder(object):
    def __init__(self) -> None:
        self._attachment_info = AttachmentInfo()

    def id(self, id: str) -> "AttachmentInfoBuilder":
        self._attachment_info.id = id
        return self

    def url(self, url: str) -> "AttachmentInfoBuilder":
        self._attachment_info.url = url
        return self

    def name(self, name: str) -> "AttachmentInfoBuilder":
        self._attachment_info.name = name
        return self

    def mime(self, mime: str) -> "AttachmentInfoBuilder":
        self._attachment_info.mime = mime
        return self

    def create_time(self, create_time: str) -> "AttachmentInfoBuilder":
        self._attachment_info.create_time = create_time
        return self

    def build(self) -> "AttachmentInfo":
        return self._attachment_info
