# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n import I18n


class Auth(object):
    _types = {
        "id": str,
        "name": I18n,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[I18n] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AuthBuilder":
        return AuthBuilder()


class AuthBuilder(object):
    def __init__(self) -> None:
        self._auth = Auth()

    def id(self, id: str) -> "AuthBuilder":
        self._auth.id = id
        return self

    def name(self, name: I18n) -> "AuthBuilder":
        self._auth.name = name
        return self

    def build(self) -> "Auth":
        return self._auth
