# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class BackgroundCheckOrderProcessInfo(object):
    _types = {
        "process": str,
        "update_time": str,
        "en_process": str,
    }

    def __init__(self, d=None):
        self.process: Optional[str] = None
        self.update_time: Optional[str] = None
        self.en_process: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BackgroundCheckOrderProcessInfoBuilder":
        return BackgroundCheckOrderProcessInfoBuilder()


class BackgroundCheckOrderProcessInfoBuilder(object):
    def __init__(self) -> None:
        self._background_check_order_process_info = BackgroundCheckOrderProcessInfo()

    def process(self, process: str) -> "BackgroundCheckOrderProcessInfoBuilder":
        self._background_check_order_process_info.process = process
        return self

    def update_time(self, update_time: str) -> "BackgroundCheckOrderProcessInfoBuilder":
        self._background_check_order_process_info.update_time = update_time
        return self

    def en_process(self, en_process: str) -> "BackgroundCheckOrderProcessInfoBuilder":
        self._background_check_order_process_info.en_process = en_process
        return self

    def build(self) -> "BackgroundCheckOrderProcessInfo":
        return self._background_check_order_process_info
