# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class BaseCity(object):
    _types = {
        "zh_name": str,
        "en_name": str,
        "code": str,
        "location_type": int,
    }

    def __init__(self, d=None):
        self.zh_name: Optional[str] = None
        self.en_name: Optional[str] = None
        self.code: Optional[str] = None
        self.location_type: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BaseCityBuilder":
        return BaseCityBuilder()


class BaseCityBuilder(object):
    def __init__(self) -> None:
        self._base_city = BaseCity()

    def zh_name(self, zh_name: str) -> "BaseCityBuilder":
        self._base_city.zh_name = zh_name
        return self

    def en_name(self, en_name: str) -> "BaseCityBuilder":
        self._base_city.en_name = en_name
        return self

    def code(self, code: str) -> "BaseCityBuilder":
        self._base_city.code = code
        return self

    def location_type(self, location_type: int) -> "BaseCityBuilder":
        self._base_city.location_type = location_type
        return self

    def build(self) -> "BaseCity":
        return self._base_city
