# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .batch_get_id_talent_request_body import BatchGetIdTalentRequestBody


class BatchGetIdTalentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[BatchGetIdTalentRequestBody] = None

    @staticmethod
    def builder() -> "BatchGetIdTalentRequestBuilder":
        return BatchGetIdTalentRequestBuilder()


class BatchGetIdTalentRequestBuilder(object):

    def __init__(self) -> None:
        batch_get_id_talent_request = BatchGetIdTalentRequest()
        batch_get_id_talent_request.http_method = HttpMethod.POST
        batch_get_id_talent_request.uri = "/open-apis/hire/v1/talents/batch_get_id"
        batch_get_id_talent_request.token_types = {AccessTokenType.TENANT}
        self._batch_get_id_talent_request: BatchGetIdTalentRequest = batch_get_id_talent_request

    def request_body(self, request_body: BatchGetIdTalentRequestBody) -> "BatchGetIdTalentRequestBuilder":
        self._batch_get_id_talent_request.request_body = request_body
        self._batch_get_id_talent_request.body = request_body
        return self

    def build(self) -> BatchGetIdTalentRequest:
        return self._batch_get_id_talent_request
