# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class BatchGetIdTalentRequestBody(object):
    _types = {
        "mobile_code": str,
        "mobile_number_list": List[str],
        "email_list": List[str],
        "identification_type": int,
        "identification_number_list": List[str],
    }

    def __init__(self, d=None):
        self.mobile_code: Optional[str] = None
        self.mobile_number_list: Optional[List[str]] = None
        self.email_list: Optional[List[str]] = None
        self.identification_type: Optional[int] = None
        self.identification_number_list: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BatchGetIdTalentRequestBodyBuilder":
        return BatchGetIdTalentRequestBodyBuilder()


class BatchGetIdTalentRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._batch_get_id_talent_request_body = BatchGetIdTalentRequestBody()

    def mobile_code(self, mobile_code: str) -> "BatchGetIdTalentRequestBodyBuilder":
        self._batch_get_id_talent_request_body.mobile_code = mobile_code
        return self

    def mobile_number_list(self, mobile_number_list: List[str]) -> "BatchGetIdTalentRequestBodyBuilder":
        self._batch_get_id_talent_request_body.mobile_number_list = mobile_number_list
        return self

    def email_list(self, email_list: List[str]) -> "BatchGetIdTalentRequestBodyBuilder":
        self._batch_get_id_talent_request_body.email_list = email_list
        return self

    def identification_type(self, identification_type: int) -> "BatchGetIdTalentRequestBodyBuilder":
        self._batch_get_id_talent_request_body.identification_type = identification_type
        return self

    def identification_number_list(self, identification_number_list: List[str]) -> "BatchGetIdTalentRequestBodyBuilder":
        self._batch_get_id_talent_request_body.identification_number_list = identification_number_list
        return self

    def build(self) -> "BatchGetIdTalentRequestBody":
        return self._batch_get_id_talent_request_body
